/*
 * Processor Status Word bits used by monitor
 */
#define	DB_PSW_ET	0x00000003
#define	DB_PSW_ISC	0x00000078
#define	DB_PSW_I	0x00000080
#define	DB_PSW_R	0x00000100
#define	DB_PSW_SUPV	0x00000000
#define	DB_PSW_USER	0x00001800
#define	DB_PSW_INTPRI	0x0001E000
#define	DB_PSW_TRACE	0x00020000
#define	DB_PSW_INTSHIFT	13
#define	DB_PSW_PRI(i)	((i) << DB_PSW_INTSHIFT) /* 0 <= i <= 15 */

/*
 * Register model for 32100
 */
#define	DB_NREGS	16
#define	DB_NREGS_USER	14
#define	DB_NREGS_32100	DB_NREGS
#define	DB_REG_R(i)	(i)	/* 0 <= i <= 15 */
#define	DB_REG_FP	9
#define	DB_REG_AP	10
#define	DB_REG_PS	11
#define	DB_REG_SP	12
#define	DB_REG_PC	13
#define	DB_REG_PCBP	14
#define	DB_REG_ISP	15

#ifndef LOCORE
struct DebugRegs {
	long	r[DB_NREGS];
};

struct cntx321 {
	int	psw;
	int	pc;
	int	sp;
};

struct gate321 {
	int	psw;
	int	pc;
};

struct pcb321 {
	struct cntx321 active;
	int stacklb;
	int stackub;
	int rsave[11];
	int blksize;
};

struct pcb321i {
	struct cntx321 init;
	struct pcb321 p;
};
#endif /* !LOCORE */

/*
 * 32100 family traps used by monitor
 */
#define	DB_TRAP_TRACE		1
#define	DB_TRAP_BUS_ERROR	5
#define	DB_TRAP_BKPT		14
